/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core;

import com.aptana.ruby.debug.core.IRubyLineBreakpoint;
import com.aptana.ruby.debug.core.model.IRubyExceptionBreakpoint;
import com.aptana.ruby.debug.core.model.IRubyStackFrame;
import com.aptana.ruby.internal.debug.core.ICommandFactory;
import com.aptana.ruby.internal.debug.core.model.RubyStackFrame;
import com.aptana.ruby.internal.debug.core.model.RubyThread;
import com.aptana.ruby.internal.debug.core.model.RubyVariable;
import org.eclipse.core.runtime.CoreException;

public class RubyDebugCommandFactory
implements ICommandFactory {
    @Override
    public String createReadFrames(RubyThread thread) {
        return "w";
    }

    @Override
    public String createReadLocalVariables(RubyStackFrame frame) {
        return "frame " + frame.getIndex() + "; v l";
    }

    public String createReadGlobalVariables() {
        return "v g";
    }

    @Override
    public String createReadInstanceVariable(RubyVariable variable) {
        StringBuilder command = new StringBuilder();
        return command.append("v i " + variable.getObjectId()).toString();
    }

    @Override
    public String createStepOver(RubyStackFrame frame) {
        return "frame " + frame.getIndex() + "; next";
    }

    @Override
    public String createForcedStepOver(RubyStackFrame frame) {
        return "frame " + frame.getIndex() + "; next+";
    }

    @Override
    public String createStepReturn(RubyStackFrame frame) {
        return "frame " + frame.getIndex() + "; finish";
    }

    @Override
    public String createStepInto(RubyStackFrame frame) {
        return "frame " + frame.getIndex() + "; step";
    }

    @Override
    public String createForcedStepInto(RubyStackFrame frame) {
        return "frame " + frame.getIndex() + "; step+";
    }

    @Override
    public String createReadThreads() {
        return "th l";
    }

    @Override
    public String createLoad(String filename) {
        return "load " + filename;
    }

    @Override
    public String createInspect(IRubyStackFrame frame, String expression) {
        return "frame " + frame.getIndex() + "; v inspect " + expression.replaceAll(";", "\\;");
    }

    @Override
    public String createResume(RubyThread thread) {
        return "cont";
    }

    @Override
    public String createAddBreakpoint(String file, int line) {
        StringBuffer setBreakPointCommand = new StringBuffer();
        setBreakPointCommand.append("b ");
        setBreakPointCommand.append(file);
        setBreakPointCommand.append(":");
        setBreakPointCommand.append(line);
        return setBreakPointCommand.toString();
    }

    @Override
    public String createAddMethodBreakpoint(String file, String type, String method, int line) {
        StringBuffer setBreakPointCommand = new StringBuffer();
        setBreakPointCommand.append("b ");
        setBreakPointCommand.append(type);
        setBreakPointCommand.append(".");
        setBreakPointCommand.append(method);
        return setBreakPointCommand.toString();
    }

    @Override
    public String createRemoveBreakpoint(int index) {
        return "delete " + index;
    }

    @Override
    public String createCatchOff(IRubyExceptionBreakpoint breakpoint) throws CoreException {
        return "catch " + breakpoint.getTypeName() + " off";
    }

    @Override
    public String createCatchOn(IRubyExceptionBreakpoint breakpoint) throws CoreException {
        return "catch " + breakpoint.getTypeName();
    }

    @Override
    public String createThreadStop(RubyThread thread) {
        return "thread stop " + thread.getId();
    }

    @Override
    public String createSetCondition(IRubyLineBreakpoint lineBreakpoint) throws CoreException {
        return "condition " + lineBreakpoint.getIndex() + " " + lineBreakpoint.getCondition();
    }
}

